/*
 * QrfeTagManipulatorInterface.h
 *
 *  Created on: 27.05.2009
 *      Author: stefan.detter
 */

#ifndef QRFETAGMANIPULATORINTERFACE_H_
#define QRFETAGMANIPULATORINTERFACE_H_

#include "epc/EPC_Defines.h"
#include "QrfeReaderInterfaceGlobal.h"

class QrfeReaderInterface;

class QrfeTagManipulatorInterface
{
public:
	QrfeTagManipulatorInterface(){};
	virtual ~QrfeTagManipulatorInterface(){};

	virtual QrfeGlobal::TMIResult readFromTag ( const QString& tagId, uchar mem_bank, ushort address, const QByteArray& passwd, uchar count, QByteArray &data ) = 0;
    virtual QrfeGlobal::TMIResult writeToTag ( const QString& tagId, uchar mem_bank, ushort address, const QByteArray& passwd, const QByteArray& data, bool retry = true) = 0;

	virtual QrfeReaderInterface*  getReaderInterface() = 0;

    virtual bool tagManipulatorCanReadToEnd() = 0;
    virtual uint tagManipulatorMaxBufferSize() { return 500; }
};

#endif /* QRFETAGMANIPULATORINTERFACE_H_ */
